﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Win32;
using Winfoot_7_SDK;
using System.Text.RegularExpressions;

namespace WinfootDefaultPerformancePlugin.Controls.Strategy
{
    public interface IMaxRequestThreadsStrategy
    {
        void Write(int num);
        WFRegistry Read();
        List<WFRegistry> BackUp();
    }

    public class MaxRequestThreadsDefaultStrategy : ICorrespondenceOS, IMaxRequestThreadsStrategy
    {
        public MaxRequestThreadsDefaultStrategy()
        {
            CorrespondenceOSList = new List<OS>
                                       {
                                           OS.WindowsXP,
                                           OS.WindoesXP_SP1,
                                           OS.WindowsXP_SP2,
                                           OS.WindowsXP_SP3,
                                           OS.WindowsVista,
                                           OS.WindowsVista_SP1,
#if DEBUG
                                           OS.WindowsVista_SP2,
                                           OS.WindowsSeven
#endif
                                       };
        }

        private string RegName = "Windows";

        #region ICorrespondenceOS メンバ

        public List<OS> CorrespondenceOSList { get; set; }

        #endregion


        public void Write(int num)
        {
            RegistryKey registryKey =
                Registry.LocalMachine.CreateSubKey(
                    @"SYSTEM\CurrentControlSet\Control\Session Manager\SubSystems");

            registryKey.SetValue(RegName,
                                 Regex.Replace(Read().Value.ToString(), "MaxRequestThreads=[0-9]+",
                                               "MaxRequestThreads=" + num), RegistryValueKind.ExpandString);
        }

        public WFRegistry Read()
        {
            RegistryKey registryKey =
                Registry.LocalMachine.OpenSubKey(
                    @"SYSTEM\CurrentControlSet\Control\Session Manager\SubSystems");


            return new WFRegistry(@"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\SubSystems",
                                  RegName, registryKey.GetValue(RegName), RegistryValueKind.ExpandString,
                                  RegOperation.ValueWrite);
            
        }

        public List<WFRegistry> BackUp()
        {
            return new List<WFRegistry> {Read()};
        }

    }

    public class MaxRequestThreadsController
    {
        public MaxRequestThreadsController(MaxRequestThreads maxRequestThreads,
                                           IMaxRequestThreadsStrategy strategy)
        {
            MaxRequestThreads = maxRequestThreads;
            Strategy = strategy;
        }

        public MaxRequestThreads MaxRequestThreads { get; set; }
        public IMaxRequestThreadsStrategy Strategy { get; set; }

        public void Read()
        {
            Match match = Regex.Match(Strategy.Read().Value.ToString(), "MaxRequestThreads=[0-9]+");
            match = Regex.Match(match.Value, "[0-9]+");
            MaxRequestThreads.SetMaxRequestThreadValue(Convert.ToInt32(match.Value));
        }

        public void Write()
        {
            Strategy.Write(MaxRequestThreads.GetMaxRequestThreadValue());
        }

        public List<WFRegistry> BackUp()
        {
            return Strategy.BackUp();
        }
    }
}